<?php

declare (strict_types=1);

namespace Drupal\rfc9557\Model;

/**
 * RFC9557 date time zone part.
 *
 * @see \Drupal\rfc9557\Model\ExtendedDateTimeParts
 */
final class TimeZoneParts {

  public function __construct(
    public string $value,
    public bool $critical = FALSE,
  ) {
  }

  /**
   * Return time zone part as a string.
   */
  public function toString(): string {
    return '['
      . ($this->critical ? '!' : '')
      . $this->value
      . ']';
  }

}
