<?php

declare (strict_types=1);

namespace Drupal\rfc9557;

/**
 * Regular expressions used for parsing RFC9557 data.
 */
final class ParseRfc9557 {

  public const DATE_PATTERN = "|^(-?\d{4,})-?(\d{2})?-?(\d{2})?|";
  public const TIME_PATTERN = "|^-?\d{4,}-\d{2}-\d{2}T(\d{2}):?(\d{2})?:?(\d{2})?|";
  public const FRACSEC_PATTERN = "|^-?\d{4,}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.(\d+)|";
  public const OFFSET_PATTERN = "#^-?\d{4,}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d+)?(\+|-)(\d{2}):(\d{2})#";
  public const Z_PATTERN = "|^-?\d{4,}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(?:\.\d+)?Z|";
  // https://datatracker.ietf.org/doc/html/rfc9557#section-4.1
  public const EXTENDED_PATTERN = "(?:\[(!?)([A-Za-z0-9/=_;:+.\-]+)\])";

}
