<?php

declare (strict_types=1);

namespace Drupal\rfc9557\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * RFC 9557 extended datetime validator.
 */
#[Constraint(
  id: 'Rfc9557',
  label: new TranslatableMarkup('RFC 9557 extended datetime', [], ['context' => 'Validation']),
)]
class Rfc9557 extends SymfonyConstraint {

  /**
   * Validate against RFC 9557.
   */
  public const MODE_STANDARDS = 'MODE_STANDARDS';

  /**
   * Strictly validate inconsistent time-offset and Time Zone combinations.
   */
  public const MODE_STRICT = 'MODE_STRICT';

  /**
   * Mode of operation, defaults to standards.
   */
  public string $mode = self::MODE_STANDARDS;

  /**
   * Invalid time zone.
   */
  public const INVALID_TIMEZONE = '54b1f96a-d6ef-4402-90d8-330883426c11';

  /**
   * Invalid date time.
   */
  public const INVALID_DATETIME = '44dcbe24-adf8-438b-b438-ab8c28c08d1b';

  /**
   * Offset and time zone inconsistent.
   */
  public const OFFSET_INCONSISTENT = '8a9337e9-35dd-4064-9a26-47a8ba42fca3';

  /**
   * Invalid date time message.
   */
  public string $invalidDatetimeMessage = 'Invalid datetime.';

  /**
   * Invalid time zone message.
   */
  public string $invalidTimeZoneMessage = 'Invalid time zone.';

  /**
   * Offset and time zone inconsistent message.
   */
  public string $offsetInconsistentMessage = 'Inconsistent offset and time zone.';

  /**
   * {@inheritdoc}
   */
  protected const ERROR_NAMES = [
    self::INVALID_TIMEZONE => 'INVALID_TIMEZONE',
    self::INVALID_DATETIME => 'INVALID_DATETIME',
    self::OFFSET_INCONSISTENT => 'OFFSET_INCONSISTENT',
  ];

}
