# Responsive Image Formatter Tools (RIFT)

RIFT provides Quality-of-Life improvements for setting up and maintaining responsive images in Drupal websites. The module offers a comprehensive toolkit for implementing responsive image strategies using modern HTML techniques.

## Key Features

- Define "Responsive Image View Modes" that implement responsive image strategies using srcset/sizes or picture elements
- Apply responsive image formatting to media fields (images) attached to content entities via field formatters
- Plugin-based architecture for extensibility (RiftSource and RiftMediaSource plugins)
- Twig functions and services for developers to implement custom responsive image solutions
- Integration with image cropping and focal point tools
- Placeholder mode for testing RIFT view mode configurations.
- Image Token (`?itok`) support.


Field Formatters are applied to Media Reference field, instead of Image field. This architecture allows supporting some advanced use cases which is not possible in other modules.

## Components

RIFT consists of:

1. **Core Module (rift)**: The main functionality including:
   - Field formatters for media entity references
   - Twig extension for template integration
   - Plugin systems for source and media source handling
   - Configuration management for responsive image strategies

2. **Submodules**:
   - **RIFT UI (rift_ui)**: Enhanced user interface for RIFT configuration. Highly recommended module for configuring RIFT. It provides advanced validation and auto-healing of configuration.

## Field Formatters

RIFT provides the following field formatters:
- **Rift Media Picture**: Formats media entity reference fields to use responsive picture elements
- **Rift Media Picture with Fallback**: Similar to the above but includes fallback options. This can be used to show images using Rift Media Picture and for other media types, it would fallback to configured media entity view mode.

## Recommended Modules

- [`image_widget_crop`](https://www.drupal.org/project/image_widget_crop): For Manual Crop support.
- [`focal_point`](https://www.drupal.org/project/focal_point): For setting point of interest on an image.
- [`crop`](https://www.drupal.org/project/crop): Used by Image Widget Crop.
- [`ace_editor`](https://www.drupal.org/project/ace_editor): Provides enhanced configuration editing experience

## Installation

Install as you would normally install a contributed Drupal module. For further information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

Before configuring the module, you should develop a responsive image strategy for your site. See the [Responsive Image Design Guide](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/responsive-image-formatter-tools-rift/responsive-image-design-guide) for guidance.

### Documentation Resources

- [Quick Start Guide](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/responsive-image-formatter-tools-rift/rift-quick-start)
- [Configuration Guide for Site Builders](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/responsive-image-formatter-tools-rift/responsive-image-design-guide/site-builder)
- [Configuration Reference](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/responsive-image-formatter-tools-rift/rift-configuration-reference)

## For Developers

RIFT provides a Twig filter called `rift_picture` that allows you to generate responsive picture markup directly in your Twig templates:

```twig
{# Using the rift_picture filter with a media entity #}
{{ node.field_image.0.entity|rift_picture({
  sizes: "120w 320w 640w 1024w 1920w",
  aspect_ratios: "1x1 16x9 16x9 4x3 4x3",
  quality: {
    1x: "80 80 70 70 60",
    2x: "40 40 40 40 40"
  },
  types: ["webp", "avif", "jpeg"]
}) }}
```

The filter accepts a media entity and a configuration array with the following options:
- `sizes`: Widths for different breakpoints
- `aspect_ratios`: Aspect ratios for each size
- `quality`: Image quality settings for both 1x and 2x pixel density
- `types`: Image formats to generate (in order of preference)

See the [complete documentation](https://www.drupal.org/docs/extending-drupal/contributed-modules/contributed-module-documentation/responsive-image-formatter-tools-rift) for more details.

## Browser Support

The responsive image techniques used by RIFT are supported by all modern browsers. Older browsers may display fallback images when configured.

## Maintainers

- Shibin Das - [D34dMan](https://www.drupal.org/u/d34dman)
