// Build information for the RIFT UI Config app
export const BUILD_INFO = {
  version: import.meta.env.VITE_APP_VERSION || "0.0.0",
  buildId: import.meta.env.VITE_BUILD_ID || generateBuildId(),
  buildTime: import.meta.env.VITE_BUILD_TIME || new Date().toISOString(),
  environment: import.meta.env.MODE || "development",
  commitHash: import.meta.env.VITE_COMMIT_HASH || "unknown"
};

function generateBuildId(): string {
  const timestamp = Date.now().toString(36);
  const random = Math.random().toString(36).substring(2, 8);
  return `${timestamp}-${random}`;
}

export function getBuildInfoString(): string {
  const env = BUILD_INFO.environment === "production" ? "" : ` (${BUILD_INFO.environment})`;
  return `v${BUILD_INFO.version}${env} | ${BUILD_INFO.buildId}`;
}

export function getFullBuildInfo(): string {
  return `RIFT UI v${BUILD_INFO.version} | Build: ${BUILD_INFO.buildId} | ${BUILD_INFO.buildTime} | Commit: ${BUILD_INFO.commitHash}`;
}

export function getShortBuildInfo(): string {
  return `${BUILD_INFO.buildId}`;
} 