# RIFT UI Config Tests

This directory contains comprehensive tests for the RIFT UI configuration form submission functionality.

## Test Structure

### `store.test.ts`
Tests the core store functionality including:
- Store transformations (converting data to/from stores)
- Store subscriptions (ensuring drupalSettings updates when stores change)
- Data validation (handling edge cases and empty data)

### `form-submission.test.ts`
Tests the form submission functionality including:
- Component rendering
- Button interactions
- API calls
- Error handling
- Toast notifications

## Running Tests

### Install Dependencies
First, install the testing dependencies:
```bash
bun install
```

### Run Tests
```bash
# Run all tests
bun test

# Run tests in watch mode
bun test --watch

# Run tests with UI
bun test:ui

# Run tests with coverage
bun test:coverage
```

## Test Coverage

The tests cover:

1. **Store Transformations**
   - `transformAspectRatiosToStore()` - converts aspect ratio arrays to store format
   - `transformConfigToStore()` - converts config objects to individual stores
   - `transformViewModesToStore()` - converts view mode configs to store format

2. **Store Subscriptions**
   - All store changes properly update the `drupalSettings` store
   - Data transformations maintain consistency between stores
   - Edge cases (empty arrays, missing properties) are handled

3. **Data Validation**
   - Empty view modes are handled correctly
   - View modes with no enabled sizes are processed properly
   - Attributes are correctly transformed and stored

4. **Form Submission**
   - Save button triggers API calls with correct payload
   - Form validation prevents submission when invalid
   - Error handling for network issues
   - Success/error toast notifications

## Mocking

The tests use mocks for:
- `fetch` API calls
- `svelte-hot-french-toast` notifications
- Console methods (to reduce test noise)

## Test Data

Test data includes realistic examples:
- Aspect ratios: `["16:9", "4:3", "1:1"]`
- Multipliers: `["1x", "2x"]` with quality settings
- Screens: mobile and desktop breakpoints
- View modes: teaser configuration with attributes
- Formats: `["webp", "jpg"]`

## Adding New Tests

When adding new functionality:

1. **Store Tests**: Add to `store.test.ts` for new store transformations or subscriptions
2. **Component Tests**: Add to `form-submission.test.ts` for UI interactions
3. **API Tests**: Add to `form-submission.test.ts` for new API endpoints
4. **Validation Tests**: Add to appropriate test file for new validation logic

## Best Practices

- Reset stores in `beforeEach()` to ensure clean state
- Use descriptive test names that explain the expected behavior
- Test both success and failure scenarios
- Mock external dependencies to isolate unit tests
- Use `waitFor()` for asynchronous operations
- Test edge cases and error conditions 