import "@testing-library/jest-dom";
import { vi } from "vitest";

// Mock fetch globally for all tests
global.fetch = vi.fn();

// Mock toast notifications for all tests
vi.mock("svelte-hot-french-toast", () => ({
  toast: {
    success: vi.fn(),
    error: vi.fn(),
    loading: vi.fn(),
    dismiss: vi.fn()
  }
}));

// Mock console methods to reduce noise in tests
global.console = {
  ...console,
  log: vi.fn(),
  debug: vi.fn(),
  info: vi.fn(),
  warn: vi.fn(),
  error: vi.fn()
};

// Setup before each test
beforeEach(() => {
  vi.clearAllMocks();
  // Reset fetch mock
  (global.fetch as any).mockClear();
});

// Cleanup after each test
afterEach(() => {
  vi.clearAllMocks();
}); 