import { defineConfig } from 'vite'
import { svelte } from '@sveltejs/vite-plugin-svelte'

// Generate build information
const buildId = Date.now().toString(36) + "-" + Math.random().toString(36).substring(2, 8);
const buildTime = new Date().toISOString();

// https://vitejs.dev/config/
export default defineConfig({
  plugins: [svelte()],
  build: {
    outDir: '../../assets/config',
    emptyOutDir: true,
    rollupOptions: {
      output: {
        entryFileNames: "[name].js",
        assetFileNames: "[name].[ext]",
      }
    }
  },
  define: {
    // Inject build information as environment variables
    "import.meta.env.VITE_BUILD_ID": JSON.stringify(buildId),
    "import.meta.env.VITE_BUILD_TIME": JSON.stringify(buildTime),
    "import.meta.env.VITE_APP_VERSION": JSON.stringify("0.3.2"),
    "import.meta.env.VITE_COMMIT_HASH": JSON.stringify("dev"),
  }
})
