<?php

namespace Drupal\rift\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Attribute for RiftBuilder plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class RiftBuilder extends Plugin {

  /**
   * Constructs a RiftBuilder attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The human-readable name of the plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $description
   *   The plugin description.
   * @param int $priority
   *   The priority of this builder (higher numbers = higher priority).
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly ?TranslatableMarkup $description = NULL,
    public readonly int $priority = 0,
  ) {}

}
