<?php

namespace Drupal\rift;

use Drupal\media\MediaInterface;
use Drupal\rift\DTO\PictureConfig;
use Drupal\rift\Html\ElementBase;

/**
 * Interface for picture element builders.
 *
 * This interface allows contrib modules to extend or override the picture
 * element generation functionality in RIFT.
 */
interface RiftBuilderInterface {

  /**
   * Builds picture element markup from sources and media.
   *
   * @param \Drupal\rift\DTO\PictureConfig $pictureConfig
   *   The picture configuration object.
   *  @param \Drupal\rift\RiftMediaSourceInterface $riftMediaSource
   *   The Media Source Plugin.
   *  @param \Drupal\rift\RiftSourceInterface $riftSource
   *   The <source> tag generator plugin.
   * @param \Drupal\media\MediaInterface|null $media
   *   The media entity.
   * @param
   *
   * @return \Drupal\rift\Html\ElementBase
   *   The built responsive picture element as render array.
   */
  public function build(PictureConfig $pictureConfig, RiftMediaSourceInterface $riftMediaSource, RiftSourceInterface $riftSource, ?MediaInterface $media = NULL): array;

  /**
   * Determines if this builder is applicable for the given context.
   *
   * @param \Drupal\rift\DTO\PictureConfig $pictureConfig
   *   The picture configuration object.
   *  @param \Drupal\media\MediaInterface|null $media
   *    The media entity.
   *
   * @return bool
   *   TRUE if this builder should handle this case, FALSE otherwise.
   */
  public function isApplicable(PictureConfig $pictureConfig, ?MediaInterface $media = NULL): bool;

  /**
   * Gets the priority of this builder.
   *
   * Higher priority builders are used first. Default priority is 0.
   *
   * @return int
   *   The priority value.
   */
  public function getPriority(): int;

}
