<?php

namespace Drupal\rijksvideo\Event;

use Drupal\media\MediaInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched during rijksvideo media entity operations.
 */
class RijksvideoEvent extends Event {

  /**
   * Event name for rijksvideo media presave.
   */
  public const RIJKSVIDEO_MEDIA_PRESAVE = 'rijksvideo.media.presave';

  /**
   * Constructs a RijksvideoEvent object.
   *
   * @param \Drupal\media\MediaInterface $entity
   *   The media entity.
   */
  public function __construct(
    protected MediaInterface $entity,
  ) {}

  /**
   * Get the media entity.
   *
   * @return \Drupal\media\MediaInterface
   *   The media entity.
   */
  public function getEntity(): MediaInterface {
    return $this->entity;
  }

  /**
   * Set the media entity.
   *
   * @param \Drupal\media\MediaInterface $entity
   *   The media entity.
   */
  public function setEntity(MediaInterface $entity): void {
    $this->entity = $entity;
  }

}
