<?php

namespace Drupal\Tests\rijksvideo\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Tests for the Rijksvideo module.
 *
 * @group rijksvideo
 */
class RijksvideoPlayerTest extends KernelTestBase {

  /**
   * Modules that need to be enabled for this test.
   *
   * @var array<int, string>
   */
  protected static $modules = [
    'file',
    'media',
    'rijksvideo',
  ];

  /**
   * Test normalizing URLs via the utility service.
   */
  public function testNormalizeUrl(): void {
    /** @var \Drupal\rijksvideo\Service\RijksvideoUtility $utility */
    $utility = $this->container->get('rijksvideo.utility');

    $urls = [
      'http://rijksoverheid.nl' => 'https://rijksoverheid.nl',
      'https://rijksoverheid.nl' => 'https://rijksoverheid.nl',
    ];

    foreach ($urls as $input => $normalized) {
      $this->assertEquals($normalized, $utility->normalizeUrl($input));
    }
  }

  /**
   * Test auto-generated name detection.
   */
  public function testIsAutoGeneratedName(): void {
    /** @var \Drupal\rijksvideo\Service\RijksvideoUtility $utility */
    $utility = $this->container->get('rijksvideo.utility');

    // Should detect UUID-like patterns.
    $this->assertTrue($utility->isAutoGeneratedName('media:rijksvideo:550e8400-e29b-41d4-a716-446655440000'));

    // Should not detect regular names.
    $this->assertFalse($utility->isAutoGeneratedName('My Video Title'));
    $this->assertFalse($utility->isAutoGeneratedName('video-test-2024'));
  }

}
