# Rivet Design System theme for Drupal

The Rivet theme for Drupal is an implementation and adaptation of the
[Rivet Design System][] from Indiana University.

[Rivet Design System]: https://rivet.iu.edu


## Requirements

This module requires the [Layout Builder][] module from Drupal core to be enabled.

[Layout Builder]: https://www.drupal.org/docs/8/core/modules/layout-builder


## Installation

Install as you would normally install a contributed Drupal theme. For further
information, see [Installing Drupal Themes][].

[Installing Drupal Themes]: https://www.drupal.org/docs/extending-drupal/themes/installing-themes


## Configuration

1.  To test the theme, you may visit `/admin/appearance` and select
    "Enable and set as default".

1.  Alternatively, you may wish to create a sub-theme for your project by
    creating a theme and setting `base theme: rivet` in your sub-theme's
    info.yml file.


## Updating

The Rivet Base Theme was created for Drupal 10 using the new starterkit theme
generation. The theme will be maintained up-to-date with Drupal core's
`starterkit_theme` theme according to the documentation for
[Tracking upstream changes][].

[Tracking upstream changes]: https://www.drupal.org/docs/core-modules-and-themes/core-themes/starterkit-theme#s-tracking-upstream-changes


### Subtheme Generation

The recommended approach to using Rivet on any Drupal site is to create a subtheme.

Use the following command:

    php core/scripts/drupal generate-theme --name "Rivet Subtheme" --path themes/custom --starterkit rivet rivet_subtheme


## Maintainers

[//]: # cSpell:disable
[//]: # Do not add maintainers to cspell-project-words file

* James Wilson - [jwilson3](https://www.drupal.org/u/jwilson3)

## Credits

This theme uses Sass variables and mixins from the
[Rivet Design System](https://github.com/indiana-university/rivet-source)
(BSD-3-Clause License) to compile Rivet-compatible custom CSS components, but
does not redistribute Rivet code. Rivet's core CSS and JS assets are pulled
directly from CDN into all rendered website pages.

This theme includes SVGs adapted from the
[Rivet Icons](https://github.com/indiana-university/rivet-icons) library,
located in the `images/rivet-icons/` directory, for use as inline SVGs.
A copy of the original BSD-3-Clause `LICENSE.txt` is included in the same folder.
