/**
 * @file
 * Initializes Rivet in the context of a Drupal site.
 */
(function (Drupal, once, Rivet) {
  Drupal.behaviors.rivet_init = {
    attach(context) {
      // Only initialize Rivet once on the document
      if (context === document) {
        once('rivet-init', 'body', context).forEach(function () {
          Rivet.init();
        });
      }
    },
  };
})(Drupal, once, window.Rivet);
