<?php

/**
 * @file
 * Admin page callbacks for the rlogin module.
 */

/**
 * Implementation of hook_settings().
 */
function rlogin_admin_settings() {
  global $base_url;
  $form['rlogin_css_url'] = array(
    '#type' => 'textfield',
    '#title' => t('Style sheet URL'),
    '#default_value' => variable_get('rlogin_css_url', ''),
    '#size' => 60,
    '#maxlength' => 244,
    '#description' => t('Specify the full URL of the cascading style sheet (CSS) you want to have applied to the HTML remote login form.  Usually, one includes this HTML form into their own website using the iframe or object HTML tag, and the style sheet of the embedding document does <strong>not</strong> apply to the embedded HTML form; it must be styled via the style sheet designated here.  It can, of course, be the same style sheet used by the embedding document.'),
  );

  $form['legend'] = array(
    '#value' => t('Below is a sample HTML form which is output when referencing your site\'s URL ' . $base_url .'/rlogin.  You may use this to learn the HTML elements, classes and identifiers used in the form which can be referenced and altered by your style sheet.'),
  );
  $form['html'] = array(
    '#type' => 'fieldset',
    '#title' => t('Sample HTML form'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form['html']['form'] = array(
    '#value' => '<p>' . nl2br(check_plain(drupal_get_form(LOGIN_FORM))) . '</p>',
  );

  $form['rlogin_link_text'] = array(
    '#type' => 'textfield',
    '#title' => t('Logged-in link text'),
    '#default_value' => variable_get('rlogin_link_text', t('Visit ') . variable_get('site_name', check_plain($base_url)) ),
    '#size' => 60,
    '#maxlength' => 60,
    '#description' => t('When the user has already logged into your site, it does not make sense to present them with a login form on the remote site.  Instead, a link to your home page is presented.  This setting allows you to choose the text presented in the link.'),
  );

  $form['#validate'][] = 'rlogin_admin_settings_validate';
  $form = system_settings_form($form);
  return $form;
}

function rlogin_admin_settings_validate($form, &$form_state) {
}
