# Robots Rerouter

**Robots Rerouter** is a lightweight Drupal module that dynamically serves a `robots.txt` file based on the environment your site is running in. It ensures that only your **production domain** delivers a real, crawlable `robots.txt`, while all other environments (like staging or development) serve a `Disallow: *` response — blocking bots by default.

🛡️ Safe by default.  
🚀 No filesystem hacks required.  
💼 Perfect for CI/CD, Acquia, multisite, and Composer-based builds.

---

## 🚀 Features

- Dynamically overrides `/robots.txt` via routing
- Detects environment by comparing current hostname to a configured **production domain**
- Serves one of two configurable files:
  - ✅ A real robots.txt (e.g., `public://robots/good_robots.txt`)
  - ❌ A fallback "Disallow All" version (e.g., `public://robots/nocrawl_robots.txt`)
- Admin UI to configure:
  - Production domain
  - File paths for production/fallback files
- Automatically creates missing `robots/` folder and file placeholders on first request
- Prevents accidental indexing of non-production environments
- Works even on restricted platforms (like Acquia) where docroot access is limited

---

## 🛠 Installation

1. Place the module under:
   ```
   modules/custom/robots_rerouter
   ```

2. Enable it:
   ```bash
   drush en robots_rerouter
   ```

3. Visit the configuration form:
   ```
   /admin/config/search/robots-rerouter
   ```

---

## ⚙️ Configuration

| Setting | Description |
|--------|-------------|
| **Production Site Hostname** | The domain (e.g. `www.example.com`) allowed to serve the real robots.txt |
| **Production robots.txt Path** | Path to the file served in production (default: `public://robots/good_robots.txt`) |
| **Fallback robots.txt Path** | Path to the fallback file for non-production (default: `public://robots/nocrawl_robots.txt`) |

---

## 📁 File Behavior

If either the `good_robots.txt` or `nocrawl_robots.txt` file **does not exist**, the module will:

- Create the `robots/` folder inside `public://` if needed
- Create an empty placeholder file (you can edit these later via SFTP or File Manager)

📝 Default fallback contents if the file is missing:
```txt
User-agent: *
Disallow: /
```

---

## 🧪 Example

- **Production domain**: `www.example.com`
- **Staging domain**: `stage.example.com`

With this config:
```yaml
production_site: 'www.example.com'
production_file: 'public://robots/good_robots.txt'
fallback_file: 'public://robots/nocrawl_robots.txt'
```

Then:
- ✅ `https://www.example.com/robots.txt` serves your good robots.txt
- ❌ `https://stage.example.com/robots.txt` serves:
  ```
  User-agent: *
  Disallow: /
  ```

---

## 🔐 Permissions

Only users with the `administer site configuration` permission can access the configuration form.

---

## ✅ Use Cases

- SEO-sensitive websites
- Multisite Drupal installs
- Cloud platforms (Acquia, Pantheon, Platform.sh)
- Teams using CI/CD or config-only deployments
- Environments where you **cannot modify the root filesystem**

---

## 📄 License

[GPL-2.0-or-later](https://www.drupal.org/about/licensing)

---

## 🧑‍💻 Maintainers

Maintained by [Sohaib Mahtab](https://www.drupal.org/u/smahtab)

---

## 💬 Need Help?

Open an issue in the [Drupal.org project issue queue](https://www.drupal.org/project/issues/robots_rerouter)
