// These files can be found in gulp/tasks.
// If you wish to add a new task, simply create a new js file in that directory.

import { series, task } from 'gulp';

import browserSync from 'browser-sync';

import {
  cssContentblocksDev,
  cssContentblocksProd,
  cssFeaturesDev,
  cssFeaturesProd,
  cssSDCDev,
  cssSDCProd,
  cssThemeDev,
  cssThemeProd,
} from './gulp/tasks/css.mjs';
import { dev, prod } from './gulp/tasks/default.mjs';
import { iconsFont } from './gulp/tasks/icons-font.mjs';
import { watch } from './gulp/tasks/watch.mjs';
import { setup } from "./gulp/tasks/setup.mjs";
import { cssLint } from "./gulp/tasks/css-lint.mjs";
import { favicon } from "./gulp/tasks/favicon.mjs";
import { iconsSprite } from "./gulp/tasks/icons-sprite.mjs";

import { images } from './gulp/tasks/images.mjs';
import { jsLint } from "./gulp/tasks/js-lint.mjs";

const bs = browserSync.create('bs');

task('images', cb => images(cb));
task('css:theme:dev', cssThemeDev);
task('css:contentblocks:dev', cssContentblocksDev);
task('css:features:dev', cssFeaturesDev);
task('css:sdc:dev', cssSDCDev);

task('css:theme:prod', cssThemeProd);
task('css:contentblocks:prod', cssContentblocksProd);
task('css:features:prod', cssFeaturesProd);
task('css:sdc:prod', cssSDCProd);


function sync(done) {
  bs.init({
    proxy: "https://chmods-website.ddev.site",
    online: false,
    watch: true,
    open: false,
    files: [
      './css',
      './components/**/components/**/*.css',
    ],
    ui: false,
    reloadDelay: 50,
  });

  done();
}

task('watch', (done) => {
  watch(done);
  sync(done);
  done();
});

task('prod', prod);
task('dev', dev);

task('icons:font', iconsFont);
task('icons:sprite', cb => iconsSprite(cb));

task('setup', setup);

task('css:lint', cssLint);

task('favicon', (callback) => favicon(callback));

task('css:lint:precommit', cssLint);
task('js:lint:precommit', jsLint);

task('default', series(dev, sync, watch));
