<?php

// phpcs:ignoreFile

/**
 * @file
 */

use Twig\TwigFunction;

$function = new TwigFunction('icon', function($name = '', $classes = []) {
  if (is_string($classes)) {
    $classes = [$classes];
  }

  return [
    '#type' => 'inline_template',
    '#template' => '<span class="wrapper--rs-icon"><svg class="rs-icon rs-icon--{{ name }}{% for class in classes %} {{class}}{% endfor %}" role="img" aria-hidden="true" xmlns:xlink="http://www.w3.org/1999/xlink"><use xlink:href="#rs-icon--{{ name }}"></use></svg></span>',
    '#context' => [
      'name' => $name,
      'classes' => $classes,
    ],
  ];
}, [
  'needs_context' => true,
  'is_safe' => ['html'],
]);
