/*jslint node: true */

import path from 'node:path';

const themePath = process.cwd();
const themeName = path.basename(process.cwd());

// fetch command line arguments
// https://www.sitepoint.com/pass-parameters-gulp-tasks/
let arg = (argList => {
  let arg = {}, a, opt, thisOpt, curOpt;
  for (a = 0; a < argList.length; a++) {
    thisOpt = argList[a].trim();
    opt = thisOpt.replace(/^\-+/, '');

    if (opt === thisOpt) {
      // argument value
      if (curOpt) arg[curOpt] = opt;
      curOpt = null;
    }
    else {
      // argument name
      curOpt = opt;
      arg[curOpt] = true;
    }
  }
  return arg;
})(process.argv);

let config = {
  // We can pass variables to various gulp tasks in Terminal
  // The variable gets stored into the 'arg' object here below
  // Some of these have defaults, as you can see here

  // only share certain arguments from Terminal
  // and give them a default value
  arg: {
    delay: arg.projectDelay || false,
    url: arg.projectUrl || false, // 'http://PROJECT_NAME.docker.localhost:81'
  },
  // file locations
  paths: {
    base: './',
    theme: themePath,
  },
  themeName: themeName,
  htmlTwig: './components/00-theme/05-pages/html/html.html.twig',
  html: './components/00-theme/05-pages/html',
  iconfont: {
    src: 'icons/**/*.svg',
    dest: 'fonts/iconfont',
    fontName: 'iconfont',
    mixinsDest: './../../components/00-theme/00-base/01-helpers/02-mixins/_mixins-iconfont.scss',
    classesDist: './../../components/00-theme/style.iconfont-classes.scss',
    jsonDist: './iconfont.json',
    mixinsTemplate: './gulp/templates/_iconfont-mixins.scss',
    classesTemplates: './gulp/templates/_iconfont-classes.scss',
    jsonTemplate: './gulp/templates/iconfont.json',
  },
  sprite: {
    src: 'icons/**/*.svg',
    src_folder: 'icons',
    svg_css: 'images/generated/sprite-css.svg',
    svg_inline: 'images/generated/sprite-inline.svg',
    css: './components/00-theme/00-base/01-helpers/02-mixins/_mixins-sprite.scss',
    css2: './components/00-theme/00-base/09-icons/_icons-sprite.scss',
    template: './gulp/templates/_sprite.scss',
    template2: './gulp/templates/_sprite-classes.scss',
    icon_list: './components/00-theme/00-base/09-icons/iconsprite.json',
  },
  fonts: {
    src: './css/style.fonts.css',
    dest: './css',
  },
  images: {
    src: './images/source/**/*.{jpg,jpeg,png,svg}',
    dest: './images/generated',
  },
  css: {
    src: [
      'components/00-theme/**/*.scss',
      'components/01-content-blocks/**/*.scss',
      'components/02-features/**/*.scss',
      '!components/**/components/**/*.scss',
      '!components/*/00-base/_libs.scss',
      '!components/*/00-base/01-helpers/05-templates/*.scss',
      '!components/*/00-base/04-vendors/**/*.scss',
      '!components/*/tpl/**/*.scss',
      '!components/*/css/**/*.scss',
    ],
    dest: 'css',
    base: {
      src: [
        'components/00-theme/00-base/**/*.scss',
        'components/00-theme/01-atoms/**/*-helpers.scss',
        '!components/**/components/**/*.scss',
        '!components/*/00-base/_libs.scss',
        '!components/*/00-base/01-helpers/05-templates/*.scss',
        '!components/*/00-base/04-vendors/**/*.scss',
        '!components/*/tpl/**/*.scss',
        '!components/*/css/**/*.scss',
      ],
    },
    components: {
      theme: {
        src: [
          'components/00-theme/**/*.scss',
          '!components/**/components/**/*.scss',
          '!components/*/00-base/_libs.scss',
          '!components/*/00-base/01-helpers/05-templates/*.scss',
          '!components/*/00-base/04-vendors/**/*.scss',
          '!components/*/tpl/**/*.scss',
          '!components/*/css/**/*.scss',
        ],
      },
      contentblocks: {
        src: [
          'components/00-theme/00-base/**/*.scss',
          'components/01-content-blocks/**/*.scss',
          '!components/01-content-blocks/components/**',
        ],
      },
      sdc: {
        src: [
          'components/**/*.scss',
          '!components/**/_*.scss',
          '!components/**/style.scss',
          '!components/**/style.*.scss',
          '!components/**/04-vendors/**/*.scss',
        ],
      },
      features: {
        src: [
          'components/00-theme/00-base/**/*.scss',
          'components/02-features/**/*.scss',
          '!components/**/components/**/*.scss',
        ],
      },
    },
    mail: {
      src: ['css/style.mail.css'],
      dest: './',
    },
    editor: {
      src: ['css/style.editor.css'],
      dest: 'css',
    },
  },
  js: {
    src: [
      'components/00-theme/00-base/**/*.js',
      'components/00-theme/**/*.js',
      'components/01-content-blocks/**/*.js',
      'components/02-features/**/*.js',
      '!components/00-theme/**/*.min.js',
      '!components/00-theme/00-base/**/*.min.js',
    ],
    dest: 'js/dest',
    tmp: 'js/tmp',
    global: {
      src: [
        'components/00-theme/00-base/**/*.js',
        '!components/00-theme/00-base/**/*.min.js',
        '!components/**/components/**/*.js',
      ],
    },
    components: {
      src: [
        'components/00-theme/**/*.js',
        'components/01-content-blocks/**/*.js',
        'components/02-features/**/*.js',
        '!components/**/components/**/*.js',
        '!components/00-theme/00-base/**/*.js',
        '!components/00-theme/**/*.min.js',
      ],
      theme: {
        src: [
          'components/00-theme/**/*.js',
          '!components/**/components/**/*.js',
          '!components/00-theme/00-base/**/*.js',
          '!components/00-theme/**/*.min.js',
        ],
      },
      contentblocks: {
        src: [
          'components/01-content-blocks/**/*.js',
        ],
      },
      features: {
        src: [
          'components/02-features/**/*.js',
        ],
      },
    },
  },
  jshint: {
    "esversion": 11,
  },
  favicon: {
    datafile: './favicons/generated/faviconData.json',
    master: {
      SVG: './favicons/source/favicon.svg',
      SVGMobile: './favicons/source/favicon-mobile.svg',
      PNG: './favicons/source/favicon.png',
      PNGMobile: './favicons/source/favicon-mobile.png',
    },
    src: './favicons/source/',
    dest: './favicons/generated/',
    srcico: './favicons/generated/favicon.ico',
  },
  stylelintConfig: {
    'ignoreFiles': [
      '**/04-vendors/**',
    ],
    "plugins": [
      "stylelint-order",
    ],
    "rules": {
      "font-family-no-duplicate-names": true,
      "font-family-no-missing-generic-family-keyword": true,
      "function-name-case": "lower",
      "function-url-quotes": "always",
      "unit-no-unknown": true,
      "value-keyword-case": "lower",
      "declaration-block-no-duplicate-properties": [ true, {
        "ignore": ["consecutive-duplicates-with-different-values"]
      } ],
      "declaration-block-no-shorthand-property-overrides": true,
      "declaration-block-single-line-max-declarations": 1,
      "block-no-empty": true,
      "selector-attribute-quotes": "always",
      "selector-pseudo-element-colon-notation": "double",
      "selector-type-case": "lower",
      "selector-max-id": 1,
      "selector-max-specificity": ["1,3,3", {
        ignoreSelectors: ["html", "body", ":global", ":local"]
      }],
      "comment-whitespace-inside": "always",
      "max-nesting-depth": [5, {
        ignore: ["blockless-at-rules", "pseudo-classes"],
        ignoreAtRules: [ "/^if/", "/^else/", "/^media/", "/^include/"],
      }],
      "no-duplicate-selectors": true,
      "order/properties-order": [
        {
          groupName: "Positioning",
          order: "flexible",
          properties: [
            "position",
            "z-index",
            "top",
            "right",
            "bottom",
            "left",
          ],
        },
        "display",
        {
          groupName: "Box model: behavior",
          order: "flexible",
          properties: [
            "float",
            "overflow",
            "overflow-x",
            "overflow-y",
            "box-sizing",
            "flex",
            "flex-basis",
            "flex-direction",
            "flex-flow",
            "flex-grow",
            "flex-shrink",
            "flex-wrap",
            "order",
            "align-content",
            "align-items",
            "align-self",
            "justify-content",
            "justify-items",
            "justify-self",
          ],
        },
        {
          groupName: "Box model: dimensions",
          order: "flexible",
          properties: [
            "height",
            "min-height",
            "max-height",
            "width",
            "min-width",
            "max-width",
            "margin",
            "padding",
          ],
        },
        "border",
        {
          groupName: "Border group 1",
          order: "flexible",
          properties: [
            "border-width",
            "border-style",
            "border-color",
          ],
        },
        "border-image",
        {
          groupName: "Border group 2",
          order: "flexible",
          properties: [
            "border-image-source",
            "border-image-slice",
            "border-image-width",
            "border-image-outset",
            "border-image-repeat",
          ],
        },
        {
          groupName: "Border group 3",
          order: "flexible",
          properties: [
            "border-top",
            "border-right",
            "border-bottom",
            "border-left",
          ],
        },
        {
          groupName: "Border group 4",
          order: "flexible",
          properties: [
            "border-top-style",
            "border-top-width",
            "border-top-color",
            "border-right-style",
            "border-right-width",
            "border-right-color",
            "border-bottom-style",
            "border-bottom-width",
            "border-bottom-color",
            "border-left-color",
            "border-left-style",
            "border-left-width",
          ],
        },
        "border-radius",
        {
          groupName: "Border group 5",
          order: "flexible",
          properties: [
            "border-top-left-radius",
            "border-top-right-radius",
            "border-bottom-left-radius",
            "border-bottom-right-radius",
          ]
        },
        "list-style",
        {
          groupName: "List",
          order: "flexible",
          properties: [
            "list-style-type",
            "list-style-position",
            "list-style-image",
          ],
        },
        "font",
        {
          groupName: "Font",
          order: "flexible",
          properties: [
            "font-family",
            "font-size",
            "font-weight",
            "line-height",
            "text-align",
            "text-decoration",
            "text-indent",
            "text-shadow",
            "text-rendering",
            "letter-spacing",
            "vertical-align",
            "white-space",
            "word-break",
            "word-spacing",
          ],
        },
        "color",
        "background",
        {
          groupName: "Background group",
          order: "flexible",
          properties: [
            "background-color",
            "background-image",
            "background-position",
            "background-size",
            "background-repeat",
            "background-attachment",
            "background-clip",
            "background-origin",
          ],
        },
        "box-shadow",
        "transform",
        {
          groupName: "Transform",
          order: "flexible",
          properties: [
            "transform-origin",
            "transform-style",
            "perspective",
            "perspective-origin",
          ],
        },
        "transition",
        {
          groupName: "Transition",
          order: "flexible",
          properties: [
            "transition-property",
            "transition-duration",
            "transition-timing-function",
            "transition-delay",
          ],
        },
        "animation",
        {
          groupName: "Animation",
          order: "flexible",
          properties: [
            "animation-name",
            "animation-duration",
            "animation-timing-function",
            "animation-delay",
            "animation-iteration-count",
            "animation-direction",
            "animation-fill-mode",
            "animation-play-state",
          ],
        },
      ],
    },
  },
};

export {
  config
};
