// Lint-js Task
'use strict';

import gulp from 'gulp';
import jshint from 'gulp-jshint';
import map from 'map-stream';
import { config } from "../config.mjs";

let error = false;

const errorReporter = () => {
  return map((file, cb) => {
    if (!file.jshint.success) {
      error = true;
    }
    cb(null, file);
  });
};

const jsLint = () => {
  return gulp.src(config.js.src)
    .pipe(jshint(config.jshint))
    .pipe(jshint.reporter('default'));
};

const jsLintPrecommit = (done) => {
  return gulp.src(config.js.src)
    .pipe(jshint(config.jshint))
    .pipe(jshint.reporter('default'))
    .pipe(errorReporter())
    .on('error', function (err) {
      notify(err);
    })
    .on('end', function() {
      if (error) {
        process.exitCode = 1;
      }
      done();
    });
};

export const jsLintTask = jsLint;
export const jsLintPrecommitTask = jsLintPrecommit;

/**
 * Exports (optional, as direct exports are used above)
 */
export { jsLint };
