import fs from 'fs';
import notify from 'gulp-notify';

/**
 * Setup:
 * - favicon message
 * - …
 */
const setup = (done) => {
  // Check if the favicons are already generated
  fs.stat('./favicons/generated/faviconData.json', (err) => { // Use arrow function for concise error handling
    if (err != null) {
      notify(
        "Favicons don't exist yet. Add your image and run: gulp favicon or check README.md in favicons/source"
      );
    }
    done(); // Call done() inside the fs.stat callback
  });
};

/**
 * generic error notifications
 * - return using .on('error', (err) => { }
 */
const errorNotification = (callback, err, kill = true) => {
  const message = err.formatted ?? err;

  // console.log('self', self);

  if (kill) {
    notify().write(message);
    trow(new Error(message));
  }

  return notify().write(message);
};

export const setupTask = (done) => { // Export the task function
  return setup(done);
};

export { setup, errorNotification }; // Export the utility functions
