// Watch Files For Changes
'use strict';

import { series, watch } from 'gulp';
import { config } from '../config.mjs';
import {
  cssThemeDev,
  cssContentblocksDev,
  cssFeaturesDev,
  cssSDCDev,
  cssMail,
  cssEditor,
} from './css.mjs';
import { cssLintContentBlocks, cssLintFeatures, cssLintSdc, cssLintTheme } from './css-lint.mjs';
import { jsGlobalDev, jsComponentsDev } from './js.mjs';
import { jsLintTask as jsLint } from './js-lint.mjs';

const watchTask = (done) => {
  // Lint the Sass + compile same sources to CSS.
  watch(config.css.components.theme.src, series(cssLintTheme, cssThemeDev));
  watch(config.css.components.contentblocks.src, series(cssLintContentBlocks, cssContentblocksDev));
  watch(config.css.components.features.src, series(cssLintFeatures, cssFeaturesDev));
  watch(config.css.components.sdc.src, series(cssLintSdc, cssSDCDev));

  // Separate the mail and editor css.
  watch(config.css.mail.src, series(cssMail));
  watch(config.css.editor.src, series(cssEditor));

  // Lint the src JS + compile same sources.
  // Don't bundle the js like we did with the CSS, doesn't seem to want to
  // compile then.
  watch(config.js.global.src, series(jsLint, jsGlobalDev));
  watch(config.js.components.src, series(jsLint, jsComponentsDev));

  done();
};

export { watchTask as watch };
