<?php

declare(strict_types=1);

namespace Drupal\rokka\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Rokka Metadata entities.
 */
interface RokkaMetadataInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface {

  /**
   * Gets the Rokka Metadata name.
   *
   * @return string
   *   Hash of the Rokka Metadata.
   */
  public function getHash();

  /**
   * Sets the Rokka Metadata hash.
   *
   * @param string $hash
   *   The Rokka Metadata hash.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setHash($hash);

  /**
   * Returns the file size.
   *
   * @return int
   *   The file size.
   */
  public function getFileSize();

  /**
   * Sets the file size.
   *
   * @param int $file_size
   *   The file size.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setFileSize($file_size);

  /**
   * Sets the Rokka Metadata binary hash.
   *
   * @param string $binary_hash
   *   The Rokka Metadata binary_hash.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setBinaryHash($binary_hash);

  /**
   * Get the uri.
   */
  public function getUri();

  /**
   * Set the uri.
   */
  public function setUri($uri);

  /**
   * If set this returns the Rokka Metadata height.
   */
  public function getHeight(): ?int;

  /**
   * Sets the Rokka Metadata height.
   *
   * @param int $height
   *   The Rokka Metadata height.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setHeight(int $height): RokkaMetadataInterface;

  /**
   * If set this returns the Rokka Metadata width.
   */
  public function getWidth(): ?int;

  /**
   * Sets the Rokka Metadata width.
   *
   * @param int $width
   *   The Rokka Metadata $width.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setWidth(int $width);

  /**
   * Sets the Rokka Static Metadata.
   *
   * @param array $metadata
   *   The Rokka Static Metadata.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setStaticMetadata($metadata): RokkaMetadataInterface;

  /**
   * Gets the Rokka Metadata creation timestamp.
   *
   * @return array
   *   The Rokka Static Metadata.
   */
  public function getStaticMetadata();

  /**
   * Sets the Rokka Metadata image format.
   *
   * @param string $image_format
   *   The Rokka Metadata $image_format.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setFormat($image_format);

  /**
   * Gets the Rokka Metadata creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Rokka Metadata.
   */
  public function getCreatedTime();

  /**
   * Sets the Rokka Metadata creation timestamp.
   *
   * @param int $timestamp
   *   The Rokka Metadata creation timestamp.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Rokka Metadata published status indicator.
   *
   * Unpublished Rokka Metadata are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Rokka Metadata is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Rokka Metadata.
   *
   * @param bool $published
   *   TRUE to set this Rokka Metadata to published,
   *   FALSE to set it to unpublished.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setPublished($published);

  /**
   * Returns whether or not this metadata represents a video thumbnail.
   *
   * Thumbnails are special in that they do not have their own hash in Rokka,
   * but they reuse the hash of the video they were generated from. They are not
   * considered to be "source images" in Rokka, and are not supported in the
   * API like regular images.
   *
   * @return bool
   *   TRUE if this is metadata for a thumbnail.
   */
  public function isThumbnail(): bool;

  /**
   * Sets whether or not this metadata represents a video thumbnail.
   *
   * @param bool $thumbnail
   *   TRUE if this is metadata for a thumbnail.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setThumbnail(bool $thumbnail): RokkaMetadataInterface;

}
