<?php

declare(strict_types=1);

namespace Drupal\rokka\StyleEffects;

use Drupal\rokka\ImageStyleHelper;
use Rokka\Client\Core\StackOperation;

/**
 * ImageResize effect.
 */
class EffectImageResize implements ImageEffectInterface {

  /**
   * {@inheritdoc}
   */
  public static function buildRokkaStackOperation(array $data): array {

    $options = [
      'upscale' => (isset($data['upscale'])) ? (boolean) $data['upscale'] : FALSE,
      'height' => ImageStyleHelper::operationNormalizeSize($data['height']),
      'width' => ImageStyleHelper::operationNormalizeSize($data['width']),
    ];
    return [new StackOperation('resize', $options)];
  }

}
