<?php

declare(strict_types=1);

namespace Drupal\rokka;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\rokka\Entity\RokkaMetadataInterface;

/**
 * Interface for RokkaMetadata storage.
 */
interface RokkaMetadataStorageInterface extends ContentEntityStorageInterface {

  /**
   * Returns the RokkaMetadata entity matching the given URI.
   *
   * @param string $uri
   *   The URI to search for.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface|null
   *   The Rokka Metadata entity, or NULL if not found.
   */
  public function loadByUri(string $uri): ?RokkaMetadataInterface;

  /**
   * Returns the RokkaMetadata entity for a thumbnail of given video metadata.
   *
   * If the thumbnail metadata does not exist yet, it will be generated.
   *
   * @param \Drupal\rokka\Entity\RokkaMetadataInterface $videoMetadata
   *   The video metadata entity.
   * @param string $format
   *   The desired thumbnail format (e.g., 'jpg', 'png').
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface|null
   *   The Rokka Metadata entity for the thumbnail, or NULL if not found or
   *   could not be generated.
   */
  public function getThumbnail(RokkaMetadataInterface $videoMetadata, string $format = 'jpg'): ?RokkaMetadataInterface;

}
