<?php

declare(strict_types=1);

namespace Drupal\Tests\rokka\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\rokka\Entity\RokkaMetadata;
use Drupal\rokka\RokkaService;
use Rokka\Client\Image;

/**
 * Test metadata service handling.
 *
 * @group rokka
 */
class ServiceTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['rokka', 'user', 'field', 'file'];

  /**
   * The Rokka service.
   */
  protected ?RokkaService $rokka;

  /**
   * The Rokka metadata.
   */
  protected ?RokkaMetadata $exampleMetadata;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->installEntitySchema('rokka_metadata');
    $this->installEntitySchema('rokka_stack');

    $this->rokka = $this->container->get('rokka.service');

    $this->exampleMetadata = RokkaMetadata::create(
      [
        'hash' => 'h111111111111111111111111111111111111111',
        'binary_hash' => 'b111111111111111111111111111111111111111',
        'uri' => 'rokka://example.jpg',
        'format' => 'jpg',
      ]
    );
    $this->exampleMetadata->save();
  }

  /**
   * Tests the service.
   */
  public function testServiceBase(): void {
    $this->assertInstanceOf(RokkaService::class, $this->rokka);
    $this->assertInstanceOf(Image::class, $this->rokka->getRokkaImageClient());
  }

  /**
   * Tests the metadata.
   */
  public function testMetadata(): void {
    $matchingMetadata = $this->rokka->loadRokkaMetadataByUri($this->exampleMetadata->get('uri')->value);
    self::assertEquals(
      $this->exampleMetadata->getHash(),
      reset($matchingMetadata)->getHash()
    );

    self::assertEquals(
      1,
      $this->rokka->countImagesWithHash($this->exampleMetadata->getHash())
    );
  }

}
