<?php

declare(strict_types=1);

namespace Drupal\Tests\rokka\Traits;

use Drupal\rokka\Entity\RokkaMetadata;
use Drupal\Tests\RandomGeneratorTrait;

/**
 * Helper methods for creating RokkaMetadata entities.
 *
 * This trait is intended to be used in Kernel and Functional tests.
 */
trait RokkaMetadataCreationTrait {

  use RandomGeneratorTrait;

  /**
   * Creates a RokkaMetadata entity.
   *
   * @param array $values
   *   Optional field values to set on the RokkaMetadata entity instance.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadata
   *   The RokkaMetadata entity.
   */
  protected function createRokkaMetadata(array $values = []): RokkaMetadata {
    // Provide default values.
    $values += [
      'hash' => '0123456789abcdef0123456789abcdef01234567',
      'binary_hash' => '0123456789abcdef0123456789abcdef01234567',
      'uri' => 'rokka://' . $this->randomMachineName() . '.jpg',
      'format' => 'jpg',
      'filesize' => 12345,
    ];

    return RokkaMetadata::create($values);
  }

}
