<?php

declare(strict_types=1);

namespace Drupal\rokka\Entity;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\Core\Entity\EntityPublishedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for Rokka Metadata entities.
 */
interface RokkaMetadataInterface extends ContentEntityInterface, EntityChangedInterface, EntityOwnerInterface, EntityPublishedInterface {

  /**
   * Returns the Rokka Metadata hash.
   *
   * @return string
   *   Hash of the Rokka Metadata.
   */
  public function getHash(): string;

  /**
   * Sets the Rokka Metadata hash.
   *
   * @param string $hash
   *   The Rokka Metadata hash.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setHash(string $hash): RokkaMetadataInterface;

  /**
   * Returns the file size.
   *
   * @return int
   *   The file size.
   */
  public function getFileSize(): int;

  /**
   * Sets the file size.
   *
   * @param int $filesize
   *   The file size.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setFileSize(int $filesize): RokkaMetadataInterface;

  /**
   * Returns the Rokka Metadata binary hash.
   *
   * @return string
   *   The Rokka Metadata binary hash.
   */
  public function getBinaryHash(): string;

  /**
   * Sets the Rokka Metadata binary hash.
   *
   * @param string $binaryHash
   *   The Rokka Metadata binary hash.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setBinaryHash(string $binaryHash): RokkaMetadataInterface;

  /**
   * Returns the URI.
   *
   * @return string
   *   The URI.
   */
  public function getUri(): string;

  /**
   * Sets the URI.
   *
   * @param string $uri
   *   The URI.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setUri(string $uri): RokkaMetadataInterface;

  /**
   * Returns the Rokka Metadata height.
   *
   * @return int|null
   *   The Rokka Metadata height, or NULL if not set.
   */
  public function getHeight(): ?int;

  /**
   * Sets the Rokka Metadata height.
   *
   * @param int $height
   *   The Rokka Metadata height.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setHeight(int $height): RokkaMetadataInterface;

  /**
   * Returns the Rokka Metadata width.
   *
   * @return int|null
   *   The Rokka Metadata width, or NULL if not set.
   */
  public function getWidth(): ?int;

  /**
   * Sets the Rokka Metadata width.
   *
   * @param int $width
   *   The Rokka Metadata width.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setWidth(int $width): RokkaMetadataInterface;

  /**
   * Sets the Rokka Static Metadata.
   *
   * @param array $metadata
   *   The Rokka Static Metadata.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   *
   * @todo Document what this metadata can contain. The Rokka documentation
   *    mentions dynamic metadata and user metadata, but not static metadata.
   */
  public function setStaticMetadata(array $metadata): RokkaMetadataInterface;

  /**
   * Returns the Rokka static metadata.
   *
   * @return array
   *   The Rokka static metadata.
   *
   * @todo Document what this metadata can contain. The Rokka documentation
   *   mentions dynamic metadata and user metadata, but not static metadata.
   */
  public function getStaticMetadata(): array;

  /**
   * Returns the Rokka Metadata image format.
   *
   * @return string
   *   The Rokka Metadata image format.
   *
   * @todo Provide an enumeration of possible formats.
   */
  public function getFormat(): string;

  /**
   * Sets the Rokka Metadata image format.
   *
   * @param string $format
   *   The Rokka Metadata image format.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   *
   * @todo Provide an enumeration of possible formats.
   */
  public function setFormat(string $format): RokkaMetadataInterface;

  /**
   * Returns the Rokka Metadata creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Rokka Metadata.
   */
  public function getCreatedTime(): int;

  /**
   * Sets the Rokka Metadata creation timestamp.
   *
   * @param int $timestamp
   *   The Rokka Metadata creation timestamp.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setCreatedTime(int $timestamp): RokkaMetadataInterface;

  /**
   * Returns whether this metadata represents a video thumbnail.
   *
   * Thumbnails are special in that they do not have their own hash in Rokka,
   * but they reuse the hash of the video they were generated from. They are not
   * considered to be "source images" in Rokka, and are not supported in the
   * API like regular images.
   *
   * @return bool
   *   TRUE if this is metadata for a thumbnail.
   */
  public function isThumbnail(): bool;

  /**
   * Sets whether this metadata represents a video thumbnail.
   *
   * @param bool $thumbnail
   *   TRUE if this is metadata for a thumbnail.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadataInterface
   *   The called Rokka Metadata entity.
   */
  public function setThumbnail(bool $thumbnail): RokkaMetadataInterface;

}
