<?php

declare(strict_types=1);

namespace Drupal\rokka;

use Drupal\rokka\Entity\RokkaStack;
use Rokka\Client\Image;
use Rokka\Client\User;

/**
 * Rokka service interface.
 */
interface RokkaServiceInterface {

  /**
   * Get the Rokka image client.
   *
   * @return \Rokka\Client\Image
   *   Client.
   */
  public function getRokkaImageClient(): Image;

  /**
   * Get the Rokka user client.
   *
   * @return \Rokka\Client\User
   *   User.
   */
  public function getRokkaUserClient(): User;

  /**
   * Get an image, given the URI.
   *
   * @param string $uri
   *   URI.
   *
   * @return \Drupal\rokka\Entity\RokkaMetadata[]
   *   Entities.
   */
  public function loadRokkaMetadataByUri(string $uri): array;

  /**
   * Load stack by name.
   *
   * @param string $name
   *   Name.
   *
   * @return \Drupal\rokka\Entity\RokkaStack|null
   *   Stack.
   */
  public function loadStackByName(string $name): ?RokkaStack;

  /**
   * Counts the number of images that share the same Hash.
   *
   * @param string $hash
   *   Hash.
   *
   * @return int
   *   Count.
   */
  public function countImagesWithHash(string $hash): int;

  /**
   * Returns the organization name.
   *
   * @return mixed
   *   Organization name.
   */
  public function getRokkaOrganizationName();

  /**
   * Deletes the source image with the given hash.
   *
   * Deleting a source image will not remove it from the cache. Access to it
   * will fade out as the cache becomes stale.
   *
   * @param string $hash
   *   The image hash.
   *
   * @return bool
   *   TRUE if the image was deleted. FALSE if it wasn't found.
   */
  public function deleteSourceImage(string $hash): bool;

}
