<?php

namespace Drupal\role_request\Entity;

use Drupal\Core\Entity\Routing\AdminHtmlRouteProvider;
use Drupal\Core\Entity\EntityTypeInterface;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

/**
 * Provides HTML routes for role request.
 *
 * @see \Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider.
 */
class RouteProvider extends AdminHtmlRouteProvider {

  /**
   * {@inheritdoc}
   */
  protected function getAddFormRoute(EntityTypeInterface $entity_type): ?Route {
    if ($route = parent::getAddFormRoute($entity_type)) {
      $route->setOption('_admin_route', FALSE);

      // Set a static title.
      $defaults = $route->getDefaults();
      $defaults['_title'] = 'Request roles';
      unset($defaults['_title_callback']);
      $route->setDefaults($defaults);

      return $route;
    }
    return NULL;
  }

  /**
   * {@inheritdoc}
   */
  public function getRoutes(EntityTypeInterface $entity_type): RouteCollection {
    $collection = parent::getRoutes($entity_type);
    $entity_type_id = $entity_type->id();
    $route = $this->getActionFormRoute($entity_type, 'approve');
    $collection->add("entity.{$entity_type_id}.approve_form", $route);
    $route = $this->getActionFormRoute($entity_type, 'deny');
    $collection->add("entity.{$entity_type_id}.deny_form", $route);
    return $collection;
  }

  /**
   * Helper to build a route for deny or approve.
   */
  protected function getActionFormRoute(EntityTypeInterface $entity_type, string $action): Route {
    $entity_type_id = $entity_type->id();
    $route = new Route($entity_type->getLinkTemplate($action . '-form'));
    $route->addDefaults([
      '_entity_form' => "{$entity_type_id}." . $action,
      '_title' => 'Are you sure you want to ' . $action . ' role request',
    ])
      ->setRequirement('_entity_access', "{$entity_type_id}.update")
      ->setOption('parameters', [
        $entity_type_id => [
          'type' => 'entity:' . $entity_type_id,
        ],
      ]);
    // Entity types with serial IDs can specify this in their route
    // requirements, improving the matching process.
    if ($this->getEntityTypeIdKeyType($entity_type) === 'integer') {
      $route->setRequirement($entity_type_id, '\\d+');
    }
    return $route;
  }

}
