<?php

namespace Drupal\role_request;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface defining a role request entity type.
 */
interface RoleRequestInterface extends ContentEntityInterface, EntityOwnerInterface, EntityChangedInterface {

  /**
   * Helper to determine if a request is changing status to being approved.
   */
  public function isBeingApproved(): bool;

  /**
   * Helper to determine if a request is changing status to being denied.
   */
  public function isBeingDenied(): bool;

  /**
   * Gets the reques creation timestamp.
   *
   * @return int
   *   Creation timestamp of the request.
   */
  public function getCreatedTime();

}
