<?php

namespace Drupal\role_request\Form;

use Drupal\Core\Entity\ContentEntityConfirmFormBase;
use Drupal\Core\Entity\EntityDeleteFormTrait;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Form controller for the role request entity approval forms.
 */
final class RoleRequestApproveForm extends ContentEntityConfirmFormBase {

  // Complete methods like getCancelUrl.
  use EntityDeleteFormTrait;

  /**
   * {@inheritdoc}
   */
  public function getQuestion(): TranslatableMarkup {
    /** @var \Drupal\role_request\Entity\RoleRequest $entity */
    $entity = $this->getEntity();
    return $this->t('Are you sure you want to approve the role request %label?', [
      '%label' => $entity->label(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText(): TranslatableMarkup {
    return $this->t('Approve');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    /** @var \Drupal\role_request\Entity\RoleRequest $entity */
    $entity = $this->getEntity();
    $entity->set('status', '1');
    $entity->save();
  }

}
