## Introduction

The Role request module allows users to submit request for
roles and configure a role manager to approve/deny these requests.

The primary use case for this module is:

- Community site that let user apply for elevated status

## Installation

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

## Configuration

- Go to the administration for at `admin/config/people/role-request`
- Select at least one role that can be requested
- Ensure that authenticated users have permission to request roles

## Workflow

- Users can request roles from their profile page
- The request is created as "pending review"
- An administrator with permissions reviews the request and approves it denies it
- On approval the roles are granted to the user requesting them
- The request can be stored for reference but it only has effect on approval

## Features

- Emails can be configured with tokens to personalize the body
- Users can send a message along with the request to explain the reasons
- Admins can attach a note to the approval/denial of the requests

## Future features

Not currently in development but these are nice-to-haves:

- Filter out roles that have pending/denied requests to be included in the list of roles that can be requested
- Let other modules react to the roles available depending on arbitrary conditions
- Allow users to see the status of their role requests
- Request roles on registration form (optional or mandatory)
- Delete request after a approval or a certain amount of time
- Views support for requests so admins can easily apply filters.

## Maintainers

Current maintainers for Drupal 11:

- Rodrigo Aguilera (rodrigoaguilera) - https://www.drupal.org/u/rodrigoaguilera

## Similar modules

Heavily inspired by [Apply for role](https://www.drupal.org/project/apply_for_role).
Main motivation to start the Role Request module was to have a Drupal 11 compatible version
and active maintainers that can add new features. Hopefully we can join efforts in the future.
