<?php

declare(strict_types=1);

namespace Drupal\rosetta_translation\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides a block with an empty language select element.
 *
 * @Block(
 *   id = "rosetta_language_select",
 *   admin_label = @Translation("Rosetta language select")
 * )
 */
class RosettaLanguageSelectBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build(): array {
    return [
      '#markup' => '<div id="rosetta_translate_element" role="region" aria-label="Change site language"></div>',
      '#allowed_tags' => ['div'],
    ];
  }

}
