## Rosetta Translation

The Rosetta Translation module integrates the `au5ton/rosetta` project to provide site-wide automatic translation through a client widget that can use any correctly configured backend server. Administrators can configure the widget, select a Rosetta release tag (or always use latest), and control how and where translations are applied across the site.

## Table of contents

- Requirements
- Installation
- Configuration
- Troubleshooting & FAQ
- Maintainers

## Requirements

- Drupal core: 10 or 11 (`core_version_requirement: ^10 || ^11`)
- PHP: 8.1+ (recommended 8.3+)
- Network access to load the Rosetta widget from jsDelivr CDN
  - Script URL is resolved from selected tag: `https://cdn.jsdelivr.net/gh/au5ton/rosetta@<tag>/dist/index.min.js`
- A working translate backend endpoint (HTTP API) that Rosetta can call
  - Configure at “Translate backend endpoint”

Optional but recommended:
- Config Split (vary endpoints by environment)
- Admin Toolbar (easier navigation)

## Installation

1. Install the module
2. Enable the module:
   - Admin UI: Extend → Rosetta Translation → Enable
   - Or Drush: `drush en rosetta_translation -y`
3. Clear caches: `drush cr`

## Configuration

Navigate to Configuration → Regional and language → Rosetta Translation (`/admin/config/regional/rosetta-translation`).

Key settings:

- Page language
  - The source language of the document, e.g., `en`.
- Site name
  - Optional site identifier for the widget.
- Preferred supported languages
  - Comma-separated codes to limit languages shown, e.g., `es, ru, pt-PT`.
- Attribution image URL
  - Image URL displayed below the dropdown for attribution requirements.
- Logo image URL
  - Optional logo image.
- Chunk size
  - Batch size used to avoid API rate errors.
- Intersection threshold (0.0–1.0)
  - Ratio for IntersectionObserver visibility.
- Ignore intersection
  - Translate even when elements aren’t considered intersecting (not generally recommended).
- Ignore classes
  - Comma-separated class names to skip (no leading dots). Example: `pac-container, pac-logo`.
- Ignore selectors
  - Comma-separated CSS selectors to skip; uses `Element.matches()`.
- Update document lang attribute
  - Updates `<html lang>` on language change; may affect tools relying on a fixed value.
- Verbose output
  - Logs helpful debug output to the console.
- Buttons
  - JSON for custom banner buttons.
- Show banner
  - Hide/show the translation banner at the top of the page. Enabled by default.
- Included attributes
  - Attributes included in translation. Default: `title, placeholder, alt`.
- Translate backend endpoint
  - HTTP endpoint used for translation.
- Enable session and URL updates
  - Adds `?lang=` to the URL and stores the language in `sessionStorage`.
- ID of translation select widget container
  - The ID of the container element in your markup; default `rosetta_translate_element`.
- Rosetta version
  - Pick a Rosetta project release or “latest (auto)”. The module fetches tags and injects the resolved dist URL.

Add a container in your markup where you need it to render:

```html
<div id="rosetta_translate_element"></div>
```

## Troubleshooting & FAQ

- “Rosetta dist js not available.” in console
  - Verify the resolved script URL loads with HTTP 200 (Network tab).
  - Ensure your environment can reach jsDelivr.
- The language select does not appear
  - Confirm the container id matches your HTML.
  - The widget injects asynchronously; initialization waits until load.
- Translations aren’t applied to some elements
  - Adjust ignore classes/selectors or Intersection settings.
  - Ensure `included attributes` contains attributes you expect to translate.
- Backend errors
  - Check endpoint URL, authentication, and CORS settings.
- Permissions
  - The settings form requires “administer site configuration”.

## Maintainers

- Kyle Davis ([kyle.davis](https://www.drupal.org/u/kyledavis)) – Oomph, Inc. ([org](https://www.drupal.org/oomph-inc))
- Ben Hamelin ([ben.hamelin](https://www.drupal.org/u/benhamelin)) – Oomph, Inc. ([org](https://www.drupal.org/oomph-inc))
