/******/ (() => { // webpackBootstrap
/*!***********************************************************************************!*\
  !*** ./docroot/modules/custom/rosetta_translation/js/rosetta_translations.es6.js ***!
  \***********************************************************************************/
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/**
 * @file
 * Google/Rosetta language translations
 */

(function (Drupal, once, drupalSettings) {
  Drupal.behaviors.rosetta_translations = {
    attach: function attach(context) {
      var cfg = drupalSettings.rosettaTranslation || {};
      var containerId = cfg.containerId || 'rosetta_translate_element';
      once('rosetta_translations', "#".concat(containerId), context).forEach(function (translationSelect, index) {
        new TranslationSelectWidget(translationSelect);
      });
    }
  };
})(Drupal, once, drupalSettings);
var TranslationSelectWidget = /*#__PURE__*/function () {
  function TranslationSelectWidget(domNode) {
    var _this = this;
    _classCallCheck(this, TranslationSelectWidget);
    var cfg = drupalSettings.rosettaTranslation || {};
    var containerId = cfg.containerId || 'rosetta_translate_element';

    // allowed languages (array preferred; fallback to CSV string → array)
    var langList = [];
    if (Array.isArray(cfg.preferredSupportedLanguages)) {
      langList = cfg.preferredSupportedLanguages;
    } else if (typeof cfg.preferredSupportedLanguages === 'string' && cfg.preferredSupportedLanguages.trim().length > 0) {
      langList = cfg.preferredSupportedLanguages.split(',').map(function (s) {
        return s.trim();
      }).filter(function (s) {
        return s.length > 0;
      });
    }

    // search for lang param to set default language used in translation
    var searchParams = new URLSearchParams(location.search);
    if (searchParams.has("lang")) {
      var lang = searchParams.get('lang');
      if (langList.includes(lang)) {
        sessionStorage.setItem("@au5ton/translate-widget/lastLanguage", "\"" + lang + "\"");
      }
    }

    // ignore classes (array preferred; fallback to CSV string → array)
    var ignoreClasses = [];
    if (Array.isArray(cfg.ignoreClasses)) {
      ignoreClasses = cfg.ignoreClasses;
    } else if (typeof cfg.ignoreClasses === 'string' && cfg.ignoreClasses.trim().length > 0) {
      ignoreClasses = cfg.ignoreClasses.split(',').map(function (s) {
        return s.trim();
      }).filter(function (s) {
        return s.length > 0;
      });
    }

    // ignore selectors (array preferred; fallback to CSV string → array)
    var ignoreSelectors = [];
    if (Array.isArray(cfg.ignoreSelectors)) {
      ignoreSelectors = cfg.ignoreSelectors;
    } else if (typeof cfg.ignoreSelectors === 'string' && cfg.ignoreSelectors.trim().length > 0) {
      ignoreSelectors = cfg.ignoreSelectors.split(',').map(function (s) {
        return s.trim();
      }).filter(function (s) {
        return s.length > 0;
      });
    }

    // included attributes (array preferred; fallback to CSV string → array)
    var includedAttributes = [];
    if (Array.isArray(cfg.includedAttributes)) {
      includedAttributes = cfg.includedAttributes;
    } else if (typeof cfg.includedAttributes === 'string' && cfg.includedAttributes.trim().length > 0) {
      includedAttributes = cfg.includedAttributes.split(',').map(function (s) {
        return s.trim();
      }).filter(function (s) {
        return s.length > 0;
      });
    }

    // load rosetta/google translation widget
    var options = {};
    if (cfg.siteName) options.siteName = cfg.siteName;
    options.pageLanguage = cfg.pageLanguage || 'en';
    if (cfg.chunkSize) options.chunkSize = cfg.chunkSize;
    if (langList.length) options.preferredSupportedLanguages = langList;
    if (ignoreClasses.length) options.ignoreClasses = ignoreClasses;
    if (ignoreSelectors.length) options.ignoreSelectors = ignoreSelectors;
    if (cfg.verboseOutput !== undefined) options.verboseOutput = !!cfg.verboseOutput;
    if (typeof cfg.intersectionThreshold === 'number') options.intersectionThreshold = cfg.intersectionThreshold;
    if (cfg.ignoreIntersection !== undefined) options.ignoreIntersection = !!cfg.ignoreIntersection;
    if (cfg.updateDocumentLanguageAttribute !== undefined) options.updateDocumentLanguageAttribute = !!cfg.updateDocumentLanguageAttribute;
    if (includedAttributes.length) options.includedAttributes = includedAttributes;
    if (cfg.buttons) options.buttons = cfg.buttons;
    if (cfg.attributionImageUrl) options.attributionImageUrl = cfg.attributionImageUrl;
    if (cfg.logoImageUrl) options.logoImageUrl = cfg.logoImageUrl;
    if (cfg.endpoints.translate) {
      options.endpoints = {
        translate: cfg.endpoints.translate,
        supportedLanguages: '/modules/contrib/rosetta_translation/dist/languages/supportedLanguages.json'
      };
    }

    // Rosetta dist is injected by the module as an external script via html_head.
    var init = function init() {
      try {
        if (window.au5ton && typeof window.au5ton.translateWidget === 'function') {
          au5ton.translateWidget(options, containerId);
        } else if (cfg.verboseOutput) {
          console.error('Rosetta dist js not available.');
        }
      } catch (e) {
        if (cfg.verboseOutput) {
          console.error(e);
        }
      }
    };
    if (document.readyState === 'complete') {
      // If document finished loading, delay briefly to allow async script to load.
      setTimeout(init, 0);
    } else {
      // Otherwise, run on window load.
      window.addEventListener('load', function () {
        return setTimeout(init, 0);
      });
    }

    // Wire select after widget renders (it may be added asynchronously).
    var attachSelectListener = function attachSelectListener() {
      _this.selectId = domNode.querySelector('select');
      if (!_this.selectId) {
        return false;
      }
      if (cfg.sessionUrlUpdates) {
        _this.languageChanged(_this.selectId, langList);
        _this.selectId.addEventListener('change', function () {
          _this.languageChanged(_this.selectId, langList);
        });
      }
      return true;
    };

    // Try immediately in case it's already present.
    if (!attachSelectListener()) {
      var observer = new MutationObserver(function () {
        if (attachSelectListener()) {
          observer.disconnect();
        }
      });
      observer.observe(domNode, {
        childList: true,
        subtree: true
      });
      // Safety stop after 5s.
      setTimeout(function () {
        return observer.disconnect();
      }, 5000);
    }
  }

  // language changed function to handle session/url param as well as sizing of drop down.
  return _createClass(TranslationSelectWidget, [{
    key: "languageChanged",
    value: function languageChanged(selectId, langList) {
      var _this2 = this;
      // needs a delay to let rosetta do its thing first.
      setTimeout(function () {
        // Get saved data from sessionStorage
        var currentLanguage = sessionStorage.getItem("@au5ton/translate-widget/lastLanguage").replace(/['"]+/g, '');
        var searchParams = new URLSearchParams(location.search);

        // update URL param with new lang
        if (langList.includes(currentLanguage)) {
          if (!searchParams.has("lang")) {
            _this2.urlLanguageUpdate(currentLanguage);
          } else {
            var lang = searchParams.get('lang');
            if (lang != currentLanguage) {
              _this2.urlLanguageUpdate(currentLanguage);
            }
          }
        }
      }, "1000");
    }

    // update URL param with new lang
  }, {
    key: "urlLanguageUpdate",
    value: function urlLanguageUpdate(lang) {
      var searchParams = new URLSearchParams(location.search);
      searchParams.set("lang", lang.replace(/['"]+/g, ''));
      window.history.replaceState({}, '', "".concat(location.pathname, "?").concat(searchParams));
    }
  }]);
}();
/******/ })()
;
//# sourceMappingURL=rosetta_translations.js.map