# RRF Search

Reciprocal Rank Fusion (RRF) module for combining vector and traditional search results in Drupal Search API.

## Features

- Implements Reciprocal Rank Fusion algorithm for search result merging
- Seamlessly integrates with Search API
- Combines vector-based and keyword-based search results
- Improves search relevance through result fusion

## Requirements

- Drupal 10 or Drupal 11
- Search API module
- AI module (2.0+) with AI Search submodule

## Installation

### Using Composer (recommended)

```bash
composer require drupal/rrf
```

Then enable the module:

```bash
drush en rrf
```

### Manual Installation

1. Download the module from [Drupal.org](https://www.drupal.org/project/rrf)
2. Extract to `web/modules/contrib/rrf`
3. Enable via the admin interface or with Drush

## Usage

Once enabled, the RRF Search module provides a Search API processor that combines results from multiple search backends using the Reciprocal Rank Fusion algorithm.

## How RRF Works

Reciprocal Rank Fusion combines rankings from multiple search systems by:
1. Taking results from different search methods (e.g., vector search and keyword search)
2. Assigning scores based on result positions
3. Merging and re-ranking results for optimal relevance

## Contributing

Contributions are welcome! Please:

1. Check the [issue queue](https://www.drupal.org/project/issues/rrf) for existing issues
2. Follow [Drupal coding standards](https://www.drupal.org/docs/develop/standards)
3. Submit patches or merge requests via Drupal.org

## Support

- **Issue tracking**: [Drupal.org issue queue](https://www.drupal.org/project/issues/rrf)
- **Source code**: [DrupalCode Git repository](https://git.drupalcode.org/project/rrf)

## License

This project is licensed under the GPL-2.0-or-later license.
