<?php

declare(strict_types=1);

namespace Drupal\runner;

use Drupal\runner\Messenger\TaskMessage;
use Drupal\runner\Settings\SettingsInterface;
use Drupal\runner\Task\TaskInterface;
use Drupal\runner\Task\TaskManager;
use Psr\Log\LoggerInterface;
use Symfony\Component\Messenger\Envelope;
use Symfony\Component\Messenger\Exception\ExceptionInterface;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Messenger\Stamp\TransportNamesStamp;

/**
 * Trait to dispatch tasks.
 */
trait DispatchTrait {

  private readonly SettingsInterface $settings;
  private readonly MessageBusInterface $bus;
  private readonly LoggerInterface $logger;

  /**
   * Dispatch a task for processing.
   */
  public function dispatchTask(
    TaskInterface $task,
    TaskManager $task_manager,
    RunContext $run_context,
  ): void {
    $message = new TaskMessage($task, $task_manager, $run_context);
    $envelope = new Envelope(
      message: $message,
      stamps: [
        new TransportNamesStamp(
          $run_context->isDetached() ?
            $this->settings->getAsyncTransport() :
            $this->settings->getSyncTransport(),
        ),
      ],
    );

    try {
      $this->bus->dispatch($envelope);
    }
    catch (ExceptionInterface $e) {
      $this->logger->error($e->getMessage());
    }
  }

}
