<?php

declare(strict_types=1);

namespace Drupal\runner\Observer;

use Drupal\runner\Task\TaskOutput;

/**
 * Base class for observers.
 */
class Observer {

  /**
   * Called when a task produces output.
   */
  public function onMessage(TaskOutput $output): void {}

  /**
   * Called when task execution completes.
   */
  public function onEnd(): void {}

}
