<?php

declare(strict_types=1);

namespace Drupal\runner\Observer;

use Drupal\runner\Task\TaskOutput;

/**
 * Invoker for observers.
 */
readonly class ObserverInvoker implements ObserverInvokerInterface {

  /**
   * @phpstan-param array<Observer> $observers
   */
  public function __construct(
    private array $observers,
  ) {
  }

  /**
   * Loop through observers and call onMessage.
   */
  public function onMessage(TaskOutput $output): void {
    foreach ($this->observers as $observer) {
      $observer->onMessage($output);
    }
  }

  /**
   * Loop through observers and call onEnd.
   */
  public function onEnd(): void {
    foreach ($this->observers as $observer) {
      $observer->onEnd();
    }
  }

}
