<?php

declare(strict_types=1);

namespace Drupal\runner\Observer;

use Drupal\runner\Task\TaskOutput;

/**
 * Invoker for observers.
 */
interface ObserverInvokerInterface {

  /**
   * Loop through observers and call onMessage.
   */
  public function onMessage(TaskOutput $output): void;

  /**
   * Loop through observers and call onEnd.
   */
  public function onEnd(): void;

}
