<?php

declare(strict_types=1);

namespace Drupal\runner;

use Drupal\runner\Settings\Settings;
use Drupal\runner\Settings\SettingsInterface;
use Drupal\runner\Task\TaskManager;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Symfony\Component\Messenger\MessageBusInterface;

/**
 * Runner class to manage task execution.
 */
readonly class Runner {

  use DispatchTrait;

  public function __construct(
    private MessageBusInterface $bus,
    #[Autowire(service: Settings::class)]
    private SettingsInterface $settings,
    #[Autowire(service: 'logger.channel.runner')]
    private LoggerInterface $logger,
  ) {}

  /**
   * Run the next task from the task manager.
   */
  public function run(
    TaskManager $task_manager,
    RunContext $run_context,
  ): void {
    $task = $task_manager->getStartTask($run_context);

    if ($task === NULL) {
      // No more tasks to run.
      return;
    }

    $this->dispatchTask($task, $task_manager, $run_context);
  }

}
