<?php

declare(strict_types=1);

namespace Drupal\runner\Settings;

use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Module settings.
 */
final readonly class Settings implements SettingsInterface {

  public function __construct(
    public ConfigFactoryInterface $config_factory,
  ) {}

  /**
   * Get the transport for synchronous tasks.
   */
  public function getSyncTransport(): string {
    return $this->getSetting('sync_transport', 'synchronous');
  }

  /**
   * Get the transport for asynchronous tasks.
   */
  public function getAsyncTransport(): string {
    return $this->getSetting('async_transport', 'asynchronous');
  }

  /**
   * Get a setting value.
   */
  private function getSetting(string $name, ?string $default = NULL): string {
    $config = $this->config_factory->get('runner.settings');

    return $config->get($name) ?? $default;
  }

}
