<?php

declare(strict_types=1);

namespace Drupal\runner\Task;

use Drupal\runner\RunContext;

/**
 * Base class for task managers.
 */
abstract class TaskManager {

  /**
   * Get the first task to run.
   */
  abstract public function getStartTask(RunContext $run_context): ?TaskInterface;

  /**
   * Get the next task to run.
   */
  abstract public function getNextTask(RunContext $run_context): ?TaskInterface;

}
