<?php

declare(strict_types=1);

namespace Drupal\s3client;

use Aws\Credentials\Credentials;
use Aws\S3\S3Client;
use Aws\S3\S3ClientInterface;
use Drupal\Core\Site\Settings;

/**
 * Defines an s3 client factory.
 */
class S3ClientFactory implements S3ClientFactoryInterface {

  /**
   * {@inheritdoc}
   */
  public function getDefaultClient(): S3ClientInterface {
    return $this->createClient(
      Settings::get('s3client.default_key'),
      Settings::get('s3client.default_secret'),
      Settings::get('s3client.default_region'),
      Settings::get('s3client.default_endpoint'),
      Settings::get('s3client.default_bucket_endpoint', FALSE),
      Settings::get('s3client.default_version', '2006-03-01')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function createClient(string $key, string $secret, string $region, ?string $endpoint = NULL, bool $bucketEndpoint = FALSE, string $version = 'latest'): S3ClientInterface {
    $credentials = new Credentials(
      $key,
      $secret,
    );

    $options = [
      'credentials' => $credentials,
      'version' => $version,
      'region' => $region,
    ];

    if ($endpoint) {
      $options['endpoint'] = $endpoint;
      $options['bucket_endpoint'] = $bucketEndpoint;
    }

    return new S3Client($options);
  }

}
