<?php

namespace Drupal\safedelete_menu_report\EventSubscriber;

use Drupal\Core\File\FileSystemInterface;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\Core\Render\Markup;
use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpKernel\Event\RequestEvent;

class ReportMessageSubscriber implements EventSubscriberInterface {

  protected MessengerInterface $messenger;
  protected FileSystemInterface $fs;
  protected CurrentRouteMatch $routeMatch;
  protected LanguageManagerInterface $languageManager;

  public function __construct(MessengerInterface $messenger, FileSystemInterface $fs, CurrentRouteMatch $routeMatch, LanguageManagerInterface $languageManager = NULL) {
    $this->messenger = $messenger;
    $this->fs = $fs;
    $this->routeMatch = $routeMatch;
    $this->languageManager = $languageManager ?: \Drupal::languageManager();
  }

  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::REQUEST => ['onRequest', -100],
    ];
  }

  public function onRequest(RequestEvent $event): void {
    $request = $event->getRequest();
    if ($request->isXmlHttpRequest()) {
      return;
    }
    $route = $this->routeMatch->getRouteName();
    if (!in_array($route, ['system.status', 'system.admin_content'], TRUE)) {
      return;
    }

    $real = $this->fs->realpath('public://safedelete_menu_report.txt');
    if (!$real || !is_file($real)) {
      return;
    }
    $txt = @file_get_contents($real) ?: '';
    $txt = trim($txt);
    if ($txt === '') {
      return;
    }

    $lang = $this->languageManager->getCurrentLanguage();
    $url = Url::fromRoute('safedelete_menu_report.report', [], ['language' => $lang]);
    $link = Link::fromTextAndUrl(t('Click here to see the full report'), $url)->toString();

    $message = 'Safedelete menu report has identified children needing a new parent. ' . $link . ' (Last updated: ' . htmlspecialchars($txt, ENT_QUOTES, 'UTF-8') . ')';
    $this->messenger->addWarning(Markup::create($message));
  }

}
