<?php

namespace Drupal\safedelete_menu_report\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\File\FileSystemInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Render\RendererInterface;
use Drupal\Core\Lock\LockBackendInterface;
use Drupal\safedelete_menu_report\Service\ReportHelper;

class CronGenerator {

  protected ReportHelper $helper;
  protected RendererInterface $renderer;
  protected FileSystemInterface $fs;
  protected ConfigFactoryInterface $configFactory;
  protected LanguageManagerInterface $languageManager;
  protected LockBackendInterface $lock;

  public function __construct(ReportHelper $helper, RendererInterface $renderer, FileSystemInterface $fs, ConfigFactoryInterface $configFactory, LanguageManagerInterface $languageManager, LockBackendInterface $lock) {
    $this->helper = $helper;
    $this->renderer = $renderer;
    $this->fs = $fs;
    $this->configFactory = $configFactory;
    $this->languageManager = $languageManager;
    $this->lock = $lock;
  }

  public function generateReportFile(): void {
    $lock_id = 'safedelete_menu_report.generate';
    if (!$this->lock->acquire($lock_id)) {
      return;
    }
    try {
      $config = $this->configFactory->get('safedelete_menu_report.settings');
      $menus = (array) ($config->get('menus') ?? []);
      $bundle = (string) ($config->get('bundle') ?? '');
      if (!$bundle) {
        $bundle = $this->helper->resolveDefaultBundle();
      }
      $state = (string) ($config->get('moderation_state') ?? '');

      $rows_exist = FALSE;
      foreach ($menus as $menu_name) {
        if (!$menu_name) continue;
        $rows = $this->helper->buildReportRows($menu_name, $bundle, $state);
        if (!empty($rows)) { $rows_exist = TRUE; break; }
      }

      $uri = 'public://safedelete_menu_report.txt';
      $dir = 'public://';
      $this->fs->prepareDirectory($dir, FileSystemInterface::CREATE_DIRECTORY | FileSystemInterface::MODIFY_PERMISSIONS);
      if ($rows_exist) {
        $date = \Drupal::service('date.formatter')->format(\Drupal::time()->getCurrentTime(), 'custom', 'Y-m-d H:i T');
        $this->fs->saveData('true: ' . $date, $uri, FileSystemInterface::EXISTS_REPLACE);
      }
      else {
        $this->fs->saveData('', $uri, FileSystemInterface::EXISTS_REPLACE);
      }
    }
    finally {
      $this->lock->release($lock_id);
    }
  }

}
