<?php

namespace Drupal\safedelete_menu_report\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Link;
use Drupal\Core\Url;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\Request;

class MenuReportController extends ControllerBase {

  protected $helper;

  public static function create(ContainerInterface $container) {
    $instance = new static();
    $instance->helper = $container->get('safedelete_menu_report.report_helper');
    return $instance;
  }

  public function report(Request $request) {
    $build = [
      '#title' => $this->t('Safedelete Menu Report'),
    ];

    $config = $this->config('safedelete_menu_report.settings');
    $menus = $config->get('menus') ?: [];

    if (empty($menus)) {
      $link = Link::fromTextAndUrl($this->t('Safedelete settings'), Url::fromRoute('safedelete.settings'))->toString();
      $build['notice'] = [
        '#markup' => $this->t('No menus configured. Please configure menus in @link.', ['@link' => $link]),
      ];
      return $build;
    }

    $bundle = $this->helper->resolveDefaultBundle();
    $configured_bundle = $config->get('bundle') ?: $bundle;
    $configured_state = $config->get('moderation_state') ?: '';

    $state_label = $this->helper->getModerationStateLabelForBundle($configured_bundle, $configured_state) ?: $configured_state;

    $build['header'] = [
      '#theme' => 'item_list',
      '#items' => [
        $this->t('Bundle: @bundle', ['@bundle' => $configured_bundle]),
        $this->t('Moderation state: @state', ['@state' => ($state_label ?: $this->t('—'))]),
      ],
    ];

    foreach ($menus as $menu_name) {
      if (!$menu_name) {
        continue;
      }
      $rows = $this->helper->buildReportRows($menu_name, $configured_bundle, $configured_state);
      $build['table_' . $menu_name] = [
        '#type' => 'table',
        '#header' => [$this->t('Title'), $this->t('ID')],
        '#rows' => $rows,
        '#empty' => $this->t('No matching items.'),
        '#prefix' => '<h3 style="margin-top:1.25rem;">' . $this->t('Menu: @menu', ['@menu' => $menu_name]) . '</h3>',
      ];
    }

    return $build;
  }

}
