// $Id: safer_login.js,v 1.1 2010/07/18 19:34:33 richardp Exp $ 

Drupal.behaviors.saferLoginStartup = function() {
  
  
  // Add an "on submit" handler to the login form(s):
  $("form#user-login-form, form#user-login").submit(function() {

    // We only do any of this if the visitor wants us to, as indicated
    // by checking the edit-safer-login-checkbox.  OR, if that element
    // doesn't exist (because the administrator disabled it).
    // So, let's just see if it exists at all, and if so, if it is
    // unchecked.
    if ($("#edit-safer-login-checkbox").length != 0 && !$('#edit-safer-login-checkbox').is(':checked')) {
      // Okay, the checkbox is on the page and it is NOT checked.  So just return!
      return;
    }
    
    
    // Get what the user has entered for their password.
    var pass = $("#edit-pass").val();
    
    // Now, to encrypt this, we are going to first take it's MD5 hash.
    // We are assuming the jquery.md5.js file is located:
    // in /modules/safer_login/jquery_md5/jquery.md5.js and the module
    // has loaded it first.
    var pass_md5 = $.md5(pass);
    
    // Now, we take this new md5 hash, and concat with the saferLoginTokenMD5 like so:
    var new_pass_md5 = $.md5(pass_md5 + "" + Drupal.settings.saferLoginTokenMD5);
    
    // Okay, so, it is new_pass_md5 which we will pass to Drupal.  So all we need
    // to do is set the password field's value to = new_pass_md5.    
    $("#edit-pass").val(new_pass_md5);
    
    // And we're done!  We will let the form submit normally now.

  });
  
}