# Salesforce Push Queue UI

This module provides a user interface for managing the Salesforce push queue
with Views integration and bulk operations.

## Features

- **Views Integration**: Exposes the `salesforce_push_queue` database table
  to Views
- **Default View**: Pre-configured view at `/admin/config/salesforce/push-queue`
- **Bulk Operations**: VBO actions to reset failure counts and expiration times
- **Queue Management**: Overview of all queue items with filtering capabilities

## Dependencies

- `salesforce_push` - Core Salesforce Push module
- `views` - Drupal Views module
- `views_bulk_operations` - Views Bulk Operations module

## Database Schema

The module works with the `salesforce_push_queue` table which contains:

- `item_id` - Auto-increment primary key
- `name` - Salesforce mapping ID
- `entity_id` - Drupal entity ID
- `mapped_object_id` - Foreign key to salesforce_mapped_object
- `op` - Operation type (create, update, delete)
- `failures` - Number of failed attempts
- `last_failure_message` - Last failure message
- `expire` - Expiration timestamp
- `created` - Creation timestamp
- `updated` - Last update timestamp

## Available Actions

### Reset Failure Count
Resets the `failures` column to 0 and clears the `last_failure_message` for
selected queue items.

### Reset Expiration Time
Resets the `expire` column to 0, making items available for immediate
processing.

## Usage

1. Enable the module: `drush en salesforce_push_queue_ui`
2. Navigate to `/admin/config/salesforce/push-queue`
3. Use filters to find specific queue items
4. Select items and apply bulk operations as needed

## Permissions

Access to the queue management interface requires the
`administer salesforce` permission.

## Installation

This module is designed to be a contrib module candidate and should be
portable across different Drupal installations using the Salesforce suite.
